local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end

function getFloatingYModifier(self)
	return math.sin(GetTime()/(350.0+self.Width))*(15.5+self.Height/10)-self.TweakY
end

function SwitchDirection(self)
	if self.Direction == 0 then
		self.Direction = 1
	else
		self.Direction = 0
	end
	Look(self)
end

function TurnRight(self)
	self.Direction = 1
	Look(self)
end

function TurnLeft(self)
	self.Direction = 0
	Look(self)
end

function Look(self)
	if self.Direction == 0 then
		self.RutharEye.DrawFlags.Mirror = false
	else
		self.RutharEye.DrawFlags.Mirror = true
	end
end

function IncreasePatrolArea(self)
	if self.XMin ~= self.XMax and self.ClipRect.Left ~= 0 and self.ClipRect.Right ~= 0 then
		self.XMin = self.ClipRect.Left
		self.XMax = self.ClipRect.Right
		self.LeashLength = self.XMax - self.XMin
	end
end

function isLookingAtClaw(self)
	local claw = GetClaw()
	--if math.abs(self.X - claw.X) <= 64 then -- spot when player is really close
	--	return true
	--end
	if self.X < claw.X then
		if self.Direction == 1 then
			return true
		else
			return false
		end
	else
		if self.Direction == 0 then
			return true
		else
			return false
		end
	end
end

function getDistanceFromClaw(self)
	local claw = GetClaw()
	return math.abs(self.X - claw.X)
end

function getFrontDistance(self)
	if self.Direction == 1 then
		return self.XMax - self.X
	elseif self.Direction == 0 then
		return self.X - self.XMin
	end
end

function getBackDistance(self)
	if self.Direction == 1 then
		return self.X - self.XMin
	elseif self.Direction == 0 then
		return self.XMax - self.X
	end
end

function CalcMaxDistance(self, dir)
	if dir == 0 then
		return self.X - self.XMin
	else
		return self.XMax - self.X
	end
end

function ClawInLOS(self)
	--TextOut(self.sensorLFlag .. ", " .. self.sensorRFlag)
	if _CurrentPowerup[0] == 9911 then --9917
		return false
	elseif self.sensorLFlag == 1 and self.sensorRFlag == 1 then
		local claw = GetClaw()
		--TextOut(self.rangeL .. ", " .. claw.X .. ", " .. self.rangeR)
		--AttackRange = 64 -- Zealot's attack range for purpose of aggro
		if claw.Y > self.Y - 64 and claw.Y < self.Y - 32 and 
			claw.X > self.rangeL and claw.X < self.rangeR and
			claw.X > self.XMin - self.AttackRange and claw.X < self.XMax + self.AttackRange and
			isLookingAtClaw(self) then
			--TextOut(claw.X - self.X)
			return true
		end
		--TextOut(claw.Y - self.Y)
		if claw.Y > self.Y - 168 and claw.Y < self.Y - 32 and
			claw.X > self.X - self.AttackRange and claw.X < self.X + self.AttackRange and
			isLookingAtClaw(self) then
			
			return true
		end
	end
	return false
end

function main(self)
	if self.State == 0 then
		if self.XMin == 0 then
			self.XMin = self.X
		end
		if self.XMax == 0 then
			self.XMax = self.X
		end
		if self.X < self.XMin then
			self.X = self.XMin
		end
		if self.X > self.XMax then
			self.X = self.XMax
		end
		self.MoveRect = {0,0,2,2}
		if self.Smarts == 0 then
			self:AlignToGround()
		end
		self.BaseY = self.Y - 64
		--self.Z = 4001
		self.Width = math.floor(rand()*100)
		self.Height = math.floor(rand()*10)
		self.TweakY = math.floor(rand()*20)
		self.Boredom = 0
		self.Direction = math.floor(rand()+0.5)
		self.LeashLength = self.XMax - self.XMin
		self.XDestination = self.X
		self.SpeedX = 100
		self.rangeL = self.X
		self.rangeR = self.X
		self.AttackRange = 96 -- todo change for other types
		self.LastSeenClawX = nil
		self.AttackObjActive = false
		self.LookAroundsLeft = 3
		self.DrawFlags.NoDraw = true
		self.Achievements = GetObject(4088)
		self.Flag8 = 1
		if self.Speed == 1 then
			self.Flag8 = 0
		end
		if self.Achievements.HardMode == true then
			self.Speed = 1
		end
		
		if self.Speed >= 1 then
			self.Speed = 1
		end
		local img = "CUSTOM_ZEALOT"
		if self.Speed == 1 then
			img = "CUSTOM_ZEALOT2"
		end
		self.RutharEye = CreateObject {x=self.X, y=self.BaseY, z=4100, I=1, name="RutharEye", logic="CustomLogic", image=img, SpeedY = self.Y-32, Health = self.Health, UserRect1 = self.UserRect1, UserRect2 = self.UserRect2, Speed = self.Speed, Smarts = self.Smarts}
		self.sensorL = CreateObject {x=self.X, y=self.BaseY, z=4100, name="DetectorBullet", logic="CustomLogic", image="LEVEL_WOLVINGTONMAGIC", SpeedX = -1}
		self.sensorR = CreateObject {x=self.X, y=self.BaseY, z=4100, name="DetectorBullet", logic="CustomLogic", image="LEVEL_WOLVINGTONMAGIC", SpeedX = 1}
		self.sensorL.DrawFlags.NoDraw = true
		self.sensorR.DrawFlags.NoDraw = true
		self.Flags.AlwaysActive = true
		self.sensorL.Flags.AlwaysActive = true
		self.sensorR.Flags.AlwaysActive = true
		self.sensorLFlag = 0
		self.sensorRFlag = 0
		--GetObject(7098):Destroy()
		self.State = 1
		Look(self)
		self.BoredomTimer = GetTime()
		self.Flag6 = 0
		self.Flag7 = 0
	elseif self.State == 1 then
		if self.RutharEye.State == 1 then -- idle
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			self.RutharEye.I = 1
			if self.BoredomTimer + 500 < GetTime() then
			--if (GetTime() % 100) == 0 then
				self.BoredomTimer = GetTime()
				self.Boredom = self.Boredom - ( math.ceil(rand()*4)*100+10 )
			end
			if self.Boredom <= 0 then
				self.RutharEye.State = 3
			end
		--elseif self.RutharEye.State == 2 then -- taking hit
			--self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			--self.RutharEye.X = self.X
			--self.RutharEye.I = 1
			--if self.RutharEye.TempStunCounter <= GetTime() then
			--	self.RutharEye.State = 1
			--end
			--self.Boredom = 1000
		elseif self.RutharEye.State == 3 then -- wandering decision
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			if self.XMin == self.X and self.XMax == self.X then -- static
				SwitchDirection(self)
				self.Boredom = 1000 - self.Speed * 500
				self.RutharEye.State = 1
			end
			if self.X < self.XMin + self.LeashLength*0.3 then
				TurnRight(self)
				self.XDestination = self.X + math.floor(math.sqrt(rand())*CalcMaxDistance(self,1))
					
				self.RutharEye.State = 4
			elseif self.X > self.XMax - self.LeashLength*0.3 then
				TurnLeft(self)
				self.XDestination = self.X - math.floor(math.sqrt(rand())*CalcMaxDistance(self,0))
					
				self.RutharEye.State = 4
			else
				if rand() < 0.5 then
					SwitchDirection(self)
				end
				if self.Direction == 0 then
					self.XDestination = self.X - math.floor(math.sqrt(rand())*CalcMaxDistance(self,0))
				else
					self.XDestination = self.X + math.floor(math.sqrt(rand())*CalcMaxDistance(self,1))
				end
				
				self.RutharEye.State = 4
			end
			if getDistanceFromClaw(self)<700 then
				if rand() > 0.5 then
					PlaySound("CUSTOM_TRIGGER_EYE1MOVE1")
				else
					PlaySound("CUSTOM_TRIGGER_EYE1MOVE2")
				end
			end
		elseif self.RutharEye.State == 4 then -- wandering
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			self.RutharEye.I = 1
			if self.XDestination == self.X then
				self.Boredom = 1000 - self.Speed * 500
				self.RutharEye.State = 1
			end
			if self.XDestination < self.X then
				self.X = self.X - 1
			end
			if self.XDestination > self.X then
				self.X = self.X + 1
			end
		elseif self.RutharEye.State == 6 then -- lost sight of Claw nearby
			if ClawInLOS(self) then
				--self.Boredom = 1000
				self.RutharEye.State = 1
			else
				self.TimeCounter = GetTime()
				self.RutharEye.State = 10
				if rand() > 0.5 then
					PlaySound("CUSTOM_TRIGGER_EYE1ANNOYED1")
				else
					PlaySound("CUSTOM_TRIGGER_EYE1ANNOYED2")
				end
			end
		elseif self.RutharEye.State == 10 then -- cartoon looking around
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			if ClawInLOS(self) then
				self.RutharEye.State = 1
			elseif self.LookAroundsLeft <= 0 then
				--SwitchDirection(self)
				self.Boredom = 1000 - self.Speed * 500
				self.RutharEye.State = 1
			elseif self.TimeCounter + 1337 < GetTime() then
				SwitchDirection(self)
				self.RutharEye.State = 6
				self.LookAroundsLeft = self.LookAroundsLeft - 1
			end
		elseif self.RutharEye.State == 5 then -- Zealot logic / chasing Claw
			local claw = GetClaw()
			self.RutharEye.I = 2
			-- is claw still in sight range?
			if ClawInLOS(self) then
				self.LastSeenClawX = claw.X
				if getDistanceFromClaw(self) < self.AttackRange then
					self.TimeCounter = GetTime()
					self.RutharEye.State = 7
				else
					-- get closer to claw
					if self.LastSeenClawX == nil then
						self.LastSeenClawX = claw.X
					end
					if self.LastSeenClawX < self.X then
						TurnLeft(self)
						if self.Speed == 1 then
							if getFrontDistance(self) >= 4 then
								self.X = self.X - 4
							else
								self.X = self.X - 1
							end
						else
							if getFrontDistance(self) >= 4 then
								self.X = self.X - 4
							else
								self.X = self.X - 1
							end
						end
					end
					if self.LastSeenClawX > self.X then
						TurnRight(self)
						if getFrontDistance(self) >= 2 then
							self.X = self.X + 2
						else
							self.X = self.X + 1
						end
					end
				end
				self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
				self.RutharEye.X = self.X
			else
				--if getDistanceFromClaw(self) < 64 then
					-- claw trying to jump over
					--self.RutharEye.State = 6
				--else
					-- wander in the direction of claw
				if self.XMin == self.X and self.XMax == self.X then -- static
					if not isLookingAtClaw(self) then
						SwitchDirection(self)
					end
					self.Boredom = 1000 - self.Speed * 500
					self.RutharEye.State = 1
				end
				if self.LastSeenClawX == nil then
					self.LastSeenClawX = claw.X
				end
				if self.LastSeenClawX < self.XMin then
					self.XDestination = self.XMin
				elseif self.LastSeenClawX > self.XMax then
					self.XDestination = self.XMax
				else
					self.XDestination = self.LastSeenClawX
				end
				if self.X == self.XDestination then
					self.RutharEye.State = 4
				else
					if self.LastSeenClawX < self.X then
						TurnLeft(self)
						self.X = self.X - 1
					end
					if self.LastSeenClawX > self.X then
						TurnRight(self)
						self.X = self.X + 1
					end
					
					self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
					self.RutharEye.X = self.X
				end
			end
			
			--if math.abs(self.X - claw.X) <= 64 then
			
			--end
		elseif self.RutharEye.State == 7 then -- charging attack
			if not isLookingAtClaw(self) then
				SwitchDirection(self)
			end
			Look(self)
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			if self.TimeCounter + 200 < GetTime() then
				if ClawInLOS(self) or self.Speed == 1 then
					self.RutharEye.State = 8
				else
					self.LookAroundsLeft = 3
					self.RutharEye.State = 6
				end
			end
		
		elseif self.RutharEye.State == 8 then -- attack
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			PlaySound("CUSTOM_TRIGGER_ZEALOTATTACK")
			self.AttackBeam = CreateObject {x=self.X + (self.Direction-0.5)*128, y=self.BaseY, z=4100, name="ZealotAttack", logic="CustomLogic", image="CUSTOM_ZEALOT_ATTACK2"}
			self.AttackObjActive = true
			self.AttackBeam.DrawFlags.Mirror = not self.RutharEye.DrawFlags.Mirror
			self.TimeCounter = GetTime()
			self.RutharEye.State = 9
		elseif self.RutharEye.State == 9 then -- after attack
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			self.AttackBeam.Y = self.RutharEye.Y
			if self.AttackObjActive == true and self.AttackBeam.I == 13 then
				self.AttackObjActive = false
				self.AttackBeam:Destroy()
				self.AttackBeam = nil
				
				if ClawInLOS(self) then
					self.RutharEye.State = 1
				else
					self.RutharEye.I = 2
					self.LookAroundsLeft = 2
					self.RutharEye.State = 6
				end
			end
		elseif self.RutharEye.State == 11 then -- getting hit
			IncreasePatrolArea(self)
			if not isLookingAtClaw(self) then
				self.Achievements.BackStabs = self.Achievements.BackStabs + 1
				SwitchDirection(self)
			end
			if ClawInLOS(self) then
				self.RutharEye.State = 1
			else
				self.RutharEye.I = 2
				self.LookAroundsLeft = 3
				self.RutharEye.State = 6
			end
		end
		if self.RutharEye.State == 1 or self.RutharEye.State == 4 then -- do spotting
			if ClawInLOS(self) then
				self.RutharEye.State = 5
				if rand() > 0.5 then
					PlaySound("CUSTOM_TRIGGER_EYE1ANGRY1")
				else
					PlaySound("CUSTOM_TRIGGER_EYE1ANGRY2")
				end
				if not isLookingAtClaw(self) then
					SwitchDirection(self)
				end
				--TextOut(self.RutharEye.State)
			end
		end
		--TextOut(self.RutharEye.State .. ", " .. self.Boredom .. ", " .. self.XDestination)
	end
	if self.sensorLFlag == 0 then
		if self.sensorL.Collision == 1 then
			self.rangeL = self.sensorL.CollisionX
			self.sensorLFlag = 1
			self.sensorL:Destroy()
		end
	end
	if self.sensorRFlag == 0 then
		if self.sensorR.Collision == 1 then
			self.rangeR = self.sensorR.CollisionX
			self.sensorRFlag = 1
			self.sensorR:Destroy()
		end
	end
	if self.sensorLFlag == 1 and self.sensorRFlag == 1 then
		self.Flags.AlwaysActive = false
		--TextOut(self.rangeL .. ", " .. self.rangeR)
	end
	local claw = GetClaw()
	--if claw.Y > self.RutharEye.Y - 12 and claw.Y < self.RutharEye.Y - 24
	--TextOut(self.RutharEye.State)
	--TextOut(claw.Z)
	
	if self.RutharEye.Health <= 0 then
		--TextOut(self.RutharEye.Y)
		if self.Flag6 == 0 then
			self.Flag6 = 1
			self.Achievements.ReKills = self.Achievements.ReKills + 1
		end
		if self.Speed == 1 and self.Flag8 == 0 then
			self.Flag8 = 1
			self.Achievements.MutantKills = self.Achievements.MutantKills + 1
		end
		
		self.rcore = CreateObject {x=self.REX, y=self.REY, z=3900, name="RutharCore", logic="CustomLogic", image="CUSTOM_RUTHARCORE", SpeedY = self.Y-32, UserRect1 = self.UserRect1, UserRect2 = self.UserRect2, Powerup = self.Powerup}
		CreateObject {x=self.REX, y=self.REY, z=3950, name="Explosion", logic="CustomLogic", image="CUSTOM_EXPLOSION"}
		PlaySound("CUSTOM_TRIGGER_BURNING1")
		if self.Smarts == 1 then
			self.rcore.Flags.AlwaysActive = true
			if self.Flag7 == 0 then
				self.Flag7 = 1
				self.Achievements.ShootKills = self.Achievements.ShootKills + 1
			end
		end
		if self.AttackObjActive == true then
			self.AttackObjActive = false
			self.AttackBeam:Destroy()
			self.AttackBeam = nil
		end
		local cm = GetObject(4219)
		if cm.UnnaturalHunger == true then
			local claw = GetClaw()
			if claw.Health > 0 then
				claw.Health = claw.Health + 5
				cm.lastHP = claw.Health
			end
		end
		
		self.RutharEye.State = 2
		self.RutharEye.DrawFlags.NoDraw = true
		if self.rcore.Y > 0 then
			self.RutharEye:Destroy()
			self.RutharEye = nil
			self:Destroy()
		end
	end
	
	if self.RutharEye ~= nil then
		if self.RutharEye.Y > 0 and self.RutharEye.Y < 12000 then
			self.REX = self.RutharEye.X
			self.REY = self.RutharEye.Y
		end
	end
end